/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.CEAHdmiVSB;
import com.quantumdata.edideditor.DataBlock;
import com.quantumdata.edideditor.DescriptorType;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEAHdmiVendorSpecDataBlock
extends DataBlock {
    private ArrayList<CEAHdmiVSB> aHdmiVSBs;
    private static final int iVendorTag = 3;

    public CEAHdmiVendorSpecDataBlock() {
        super(31);
        this.iDataBlockTagCode = 3;
    }

    @Override
    public void removeDescriptor(int n) {
        this.aHdmiVSBs.remove(n);
        this.adjustDescriptorLength_VendorSpecific(0, 0);
    }

    @Override
    public void removeAllDescriptors() {
        this.aHdmiVSBs.clear();
        this.adjustDescriptorLength_VendorSpecific(0, 0);
    }

    @Override
    public boolean addDescriptor(CEADescriptor cEADescriptor) {
        boolean bl = false;
        if (this.aHdmiVSBs == null) {
            this.aHdmiVSBs = new ArrayList();
        }
        if (this.aHdmiVSBs.size() < this.iMaxNumberDescriptors) {
            this.aHdmiVSBs.add((CEAHdmiVSB)cEADescriptor);
            bl = true;
            this.adjustDescriptorLength_VendorSpecific(1, this.aHdmiVSBs.get(0).getDescriptorLength());
        } else {
            bl = false;
        }
        return bl;
    }

    public ArrayList<CEAHdmiVSB> getDescriptors() {
        return this.aHdmiVSBs;
    }

    public void clearDescriptors() {
        this.aHdmiVSBs.clear();
        this.aHdmiVSBs = null;
        this.adjustDescriptorLength_VendorSpecific(0, 0);
    }

    @Override
    public String getDataBlockName() {
        return DescriptorType.HDMI_VSDB_DES.getBlockName();
    }

    @Override
    public String uploadDataBlockData(String string) {
        String string2 = null;
        super.setHeader(string.substring(0, 2));
        CEAHdmiVSB cEAHdmiVSB = new CEAHdmiVSB();
        cEAHdmiVSB.uploadDescriptorData(string.substring(2, string.length()));
        if (this.aHdmiVSBs == null) {
            this.aHdmiVSBs = new ArrayList(1);
            this.aHdmiVSBs.add(cEAHdmiVSB);
            this.adjustDescriptorLength_VendorSpecific(1, this.aHdmiVSBs.get(0).getDescriptorLength());
        } else {
            string2 = "ERROR: Max descriptors already reached!";
        }
        return string2;
    }

    @Override
    public String extractDataBlockData() {
        this.adjustDescriptorLength_VendorSpecific(1, this.aHdmiVSBs.get(0).getDescriptorLength());
        String string = new String();
        string = string.concat(super.getHeader());
        if (this.getCurrentNumDescriptors() >= 1) {
            string = string.concat(this.aHdmiVSBs.get(0).extractDescriptorData());
        }
        return string;
    }

    @Override
    public boolean isJustOneCopyAllowed() {
        return true;
    }

    @Override
    public int getDataBlockChecksum() {
        String string = this.extractDataBlockData();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            n2 += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n2 & 0xFF;
    }
}

